/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.traceroute.Util;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RouteTable
implements Serializable {
    protected IPAddress ipAddress;
    protected Vector routeTable;
    protected String communityName;

    public RouteTable(IPAddress iPAddress, String string) {
        this.ipAddress = iPAddress;
        this.communityName = string;
    }

    public Enumeration getEnumeration() {
        return this.routeTable.elements();
    }

    public void debugDump() {
        Enumeration enumeration = this.getEnumeration();
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (enumeration.hasMoreElements()) {
                System.out.println(String.valueOf(Util.padString("Route Dest", 16)) + Util.padString("Next Hop", 16) + Util.padString("Type", 5) + Util.padString("Mask", 16));
            }
            while (enumeration.hasMoreElements()) {
                RouteTableRow routeTableRow = (RouteTableRow)enumeration.nextElement();
                String string = routeTableRow.getIpRouteDest().toString();
                String string2 = routeTableRow.getIpRouteNextHop().toString();
                String string3 = routeTableRow.getIpRouteType().toString();
                String string4 = routeTableRow.getIpRouteMask().toString();
                string = Util.padString(string, 16);
                string2 = Util.padString(string2, 16);
                string3 = Util.padString(string3, 5);
                string4 = Util.padString(string4, 16);
                System.out.println(String.valueOf(string) + string2 + string3 + string4);
            }
            return;
        }
    }

    public abstract class RouteTableRow
    implements Serializable {
        public abstract IPAddress getIpRouteDest();

        public abstract Integer getIpRouteIfIndex();

        public abstract Integer getIpRouteMetric1();

        public abstract Integer getIpRouteMetric2();

        public abstract Integer getIpRouteMetric3();

        public abstract Integer getIpRouteMetric4();

        public abstract Integer getIpRouteMetric5();

        public abstract IPAddress getIpRouteNextHop();

        public abstract Integer getIpRouteType();

        public abstract Integer getIpRouteProto();

        public abstract Integer getIpRouteAge();

        public abstract IPAddress getIpRouteMask();

        public abstract OID getIpRouteInfo();

        public RouteTableRow() {
            RouteTable.this = RouteTable.this;
        }
    }
}

